this.name		= "LongRangeScanner"
this.author		= "Captain Okti"
this.copyright	= "(C) 2010 Oktay Sarioglu"
this.licence		= "Creative Commons Attribution - Non-Commercial - Share Alike 3.0"
this.description= "LongRangeScanner";
this.version		= "0.311 MOD6"

"use strict";
//Original code V0.3 revised by Greyth
//To increase scanner control and reliability

//Global (to this script)
this.DebugOn=0;
//arrays holding system.allShips position, name, bounty & index values
this.ScanPos=[];
this.ScanName=[];
this.ScanBounty=[];
this.Scanner_index=[];

this.startUp = function(){}
//Display options screen
this.activated = function(){
if(player.ship.docked) return;	//Cancel operations if currently docked
if(player.ship.equipmentStatus("EQ_LONG_RANGE_SCANNER")!=="EQUIPMENT_OK") return;	//Ensure equipment is operating
player.consoleMessage(" \n \n \n \n \n \n \n \n", 1);	//Prime console message with an odd string ? what is that? I don't know yet!
timeAccelerationFactor=0.0625;	//Slow Oolite to minimum speed
mission.runScreen({title:"Long Range Scanner",message:"Scanned: "+(system.allShips.length-1)+" contacts",choicesKey:"lRangeScanner_Main"},this.choice);	//Display the scanner options screen
}

//Select appropriate action re menu choice
this.choice=function(choices){
var MenuTest=0;
//Ensure a value is assigned to 'choices'
//If it is undefined or null then don't proceed
if(!SanityCheck(choices,0)) return;	//Sanity check failed!

MenuTest=this.IsMenuOption(choices,10,"SCANNER_",1,18);	//Is menu option SCANNER_01 to 18? These are scanner contacts
if(MenuTest){
//Call scanner selection with value (minus offset of 2) to synchonise with index array
	if(DebugOn) log("Target selected: ",ScanName[missionVariables.lrangeScanner_start+MenuTest-2]);
	player.consoleMessage("Target selected: "+ScanName[missionVariables.lrangeScanner_start+MenuTest-2]);
	this.ScannerSelection(missionVariables.lrangeScanner_start+MenuTest-2);
	timeAccelerationFactor=1;	//All done
	return;
}
//Is menu option MAIN_02 to 07? These are scan types
MenuTest=this.IsMenuOption(choices,7,"Main_",2,7);
if(MenuTest){
	missionVariables.lrangeScanner_action=MenuTest;	//Set scanner filter for appropriate targets
	missionVariables.lrangeScanner_start=1;	//Reset first item to [1]. ([0] is the players own ship btw!)
	player.consoleMessage(" \n \n \n \n \n \n \n \n", 1);	//?
	this.displayScr1();	//Display scanner contacts
	return;	//All done
}
if(this.IsMenuOption(choices,7,"Jump_",1,2)){ //Is menu option Jump_01 to 02?
	this.clockSeconds = clock.adjustedSeconds;	// was clock.seconds;
	missionVariables.lrangeScanner_jumpMethod = "OPTIMIZED_BY_TIME";
	if(this.MenuSerial(choices,5,2)==2) missionVariables.lrangeScanner_jumpMethod = "OPTIMIZED_BY_JUMPS";
	this.JumpToDestination();
	return;
}

switch(choices){ //Examine remaining choices re appropriate action
	case "Main_99_EXIT":{
	timeAccelerationFactor=1;
	break;
	}
	case "SCANNER_99_EXIT":{
	timeAccelerationFactor=1;
	break;
	}
	case "SCANNER_50_EXIT":{
	missionVariables.lrangeScanner_start = missionVariables.lrangeScanner_start + 18;	//Page down
	displayScr1();
	break;
	}
	case "Main_08":{
	if(system.ID==player.ship.targetSystem){	//Display solar system information
	player.consoleMessage("LRS error: No target!")
	timeAccelerationFactor=1;
	break;
	}
	this.DisplaySystemInfo();
	break;
	}
	case "Main_01":{ //Move to Main Station
	if(system.ID<0 || system.sun.isGoingNova || system.sun.hasGoneNova){ //Stop if interstellar or system going/gone Nova(Allow Nova mission unhindered)
	timeAccelerationFactor=1;
	break;
	}
	player.ship.position=system.mainStation.position.subtract([RDist(7500,2500),RDist(7500,2500),RDist(7500,2500)]);	//Reposition ship and redress
	ScanBounty[0]=0;
	ScanPos[0]=system.mainStation.position;
	ScanName[0]=system.mainStation.displayName;
	Scanner_index[0]=EntityNumber(system.mainStation);
	this.ScannerSelection(0);
	timeAccelerationFactor=1;
	break;
	}

	default:{
	player.consoleMessage("LRS Invalid selection: "+choices+":"+MenuTest);
	timeAccelerationFactor=1;
	break;
	}
}
}

this.EntityNumber=function(Entity){
var EntityCount=system.allShips.length;
for(ELoop=0;ELoop<EntityCount;ELoop++) if(system.allShips[ELoop]===Entity) break;
if(ELoop<EntityCount) return ELoop;
}

this.displayScr1=function(){

var z=0,i=0,y=0,x=0,AssyText="",NameWidth=0;
var PageLimit=17,EntityCount=0,BountyString=0,Hash=0,MenuString="";
var SerialWidth=0,BountyWidth=0,DistanceWidth=0,ProcessEntity=0;
var ScannerResult="",ChoiceString="",counter=0,DistanceString="";
var ScanRange=system.allShips[0].scannerRange;

this.Scanner_index=[];
this.ScanBounty=[];
this.ScanName=[];
this.Scanpos=[];

EntityCount=system.allShips.length;
//Iterate ships in system
//Adding each to scan results if appropriate
for(i=1;i<EntityCount;i++) {
//If this entity is Mainstation do not process re Nova Mission
//Player must select 'Main Station' which is sensitive to that issue
	if(system.mainStation!==system.allShips[i]) ProcessEntity=1;	//Assume processing
	switch(missionVariables.lrangeScanner_action){
	case 2:{	//Lock target
	if(ScanRange<system.allShips[i].position.distanceTo(player.ship.position)) ProcessEntity=0;	//out of range	//Is it on scope?
	break;
	MenuString="LRS: Lock target";
	}
	case 4:{	//Hunt bounty
	ProcessEntity=0;	//Assume nil processing
	if((system.allShips[i].isPirate || system.allShips[i].isThargoid)||(system.allShips[i].bounty && system.allShips[i].isPiloted)) ProcessEntity=1;
	MenuString="LRS: Scan bounty"
	break;
	}
	case 5:{	//Scoop cargo
	ProcessEntity=0;	//Assume nil processing
	if(system.allShips[i].isCargo) ProcessEntity=1;
	MenuString="LRS: Scan cargo"
	break;
	}
	case 6:{	//Seek asteroids
	ProcessEntity=0;
	if(system.allShips[i].isRock) ProcessEntity=1;
	MenuString="LRS: Scan asteroids"
	break;
	}
	case 7:{	//Docking stations
	ProcessEntity=0
	if(system.allShips[i].isStation && system.allShips[i]!==system.mainStation) ProcessEntity=1;
	MenuString="LRS: Scan stations"
	break;
	}
	}
	if(ProcessEntity==1){	//Process this entity?..
//Assign serial to index
	this.Scanner_index[z]=i;
	this.ScanPos[z]=system.allShips[i].position.subtract([0,0,0]);
	this.ScanName[z]=system.allShips[i].displayName+""
	this.ScanBounty[z]=system.allShips[i].bounty-0;
//Track maximum name length
	if(defaultFont.measureString(system.allShips[i].displayName)>NameWidth) NameWidth=defaultFont.measureString(system.allShips[i].displayName);
//Track serial display requirement
	Hash=defaultFont.measureString(String(z)+")");
	if(Hash>SerialWidth) SerialWidth=Hash;
//Track bounty display requirement
	Hash=defaultFont.measureString(system.allShips[i].bounty);
	if (Hash>BountyWidth) BountyWidth=Hash;
//Track distance display requirement
	Hash=defaultFont.measureString(IntegerAsString(TargetDistance(system.allShips[i])));
	if(Hash>DistanceWidth) DistanceWidth=Hash;
//Set scanner colour if appropriate
	if(system.allShips[i].isRock && system.allShips[i].isThargoid && system.allShips[z].isCargo) if(system.allShips[i].bounty){
		system.allShips[i].scannerDisplayColor1 = "redColor";
		system.allShips[i].scannerDisplayColor2 = "yellowColor";
	}
	z++
	}
}

//All entites in system are now scanned
//Pointers to relevent items are in array Scanner_index[]
EntityCount=this.Scanner_index.length;	//Enumerate array
if(EntityCount==0){	//Any items?
	player.consoleMessage("LRS: No contacts found");
	timeAccelerationFactor=1;
	return;
}

counter=0;
ListStart=missionVariables.lrangeScanner_start;	//Recall list position
LastItem=ListStart+PageLimit;	//Calculate item page limit
if(LastItem>EntityCount) LastItem=EntityCount;	//Size page if required
ScannerResult="Contacts: "+ListStart+" to "+LastItem+" of "+EntityCount+" listed";	//Assemble scanning results string
for(x=ListStart-1;x<LastItem;x++){	//Iterate pointer array
	BountyString=BountyAsString(system.allShips[this.Scanner_index[x]].bounty,BountyWidth);	//Stringdata from bounty
//Concatenate data
	AssyText=SpacePad(x+1,SerialWidth,"L")+")"+SpacePad(system.allShips[this.Scanner_index[x]].displayName,NameWidth,"R")+" | "+BountyString+" | @"+SpacePad(IntegerAsString(TargetDistance(system.allShips[this.Scanner_index[x]])),DistanceWidth,"L");
	counter++
//Assign assembled data to appropriate mission variable
	if(counter==1) missionVariables.lrangeScanner_01=AssyText;
	if(counter==2) missionVariables.lrangeScanner_02=AssyText;
	if(counter==3) missionVariables.lrangeScanner_03=AssyText;
	if(counter==4) missionVariables.lrangeScanner_04=AssyText;
	if(counter==5) missionVariables.lrangeScanner_05=AssyText;
	if(counter==6) missionVariables.lrangeScanner_06=AssyText;
	if(counter==7) missionVariables.lrangeScanner_07=AssyText;
	if(counter==8) missionVariables.lrangeScanner_08=AssyText;
	if(counter==9) missionVariables.lrangeScanner_09=AssyText;
	if(counter==10) missionVariables.lrangeScanner_10=AssyText;
	if(counter==11) missionVariables.lrangeScanner_11=AssyText;
	if(counter==12) missionVariables.lrangeScanner_12=AssyText;
	if(counter==13) missionVariables.lrangeScanner_13=AssyText;
	if(counter==14) missionVariables.lrangeScanner_14=AssyText;
	if(counter==15) missionVariables.lrangeScanner_15=AssyText;
	if(counter==16) missionVariables.lrangeScanner_16=AssyText;
	if(counter==17) missionVariables.lrangeScanner_17=AssyText;
	if(counter==18) missionVariables.lrangeScanner_18=AssyText;
}

ChoiceString="lRangeScanner_choice";
if(counter<18){
	ChoiceString=ChoiceString+"_";
	if(counter<10) ChoiceString=ChoiceString+"0";
	ChoiceString=ChoiceString+String(counter);
}

mission.runScreen({title:MenuString,message:ScannerResult,choicesKey:ChoiceString},this.choice);	//Display scan results
}

this.ScannerSelection=function(IndexNo){
player.ship.target=null;
if(missionVariables.lrangeScanner_action!==2) this.MoveToTarget(IndexNo,7500,2500);
this.SetTarget(IndexNo);
this.FaceTarget(IndexNo);
}

this.SystemArrayNumber=function(IndexNo){
for(x=0;x<system.allShips.length;x++)if(system.allShips[x].displayName==ScanName[IndexNo]) if(system.allShips[x].bounty==ScanBounty[IndexNo]) break;
if(x<system.allShips.length) return x;
}

this.SetTarget=function(IndexNo){
if(system.allShips[Scanner_index[IndexNo]].isValid){
	if(player.ship.target!==system.allShips[Scanner_index[IndexNo]]) player.ship.target=system.allShips[Scanner_index[IndexNo]];	//Set target active target (if not already)
	return;
}
for(x=0;x<system.allShips.length;x++){
	if(system.allShips[x].displayName===ScanName[IndexNo]) if(system.allShips[x].bounty===ScanBounty[IndexNo]) if(player.ship.target!==system.allShips[x]){
	player.ship.target=system.allShips[x];
	break;
	}
}
if(x=system.allShips.length) player.commsMessage("LRS: Target seek failed!");
}

this.FaceTarget=function(IndexNo){
var TargetVector=0;
if(system.allShips[Scanner_index[IndexNo]].isValid) targetVector=system.allShips[Scanner_index[IndexNo]].position.subtract(player.ship.position).direction();
else targetVector=ScanPos[IndexNo].subtract(player.ship.position).direction();
var angle=player.ship.heading.angleTo(targetVector);
var cross=player.ship.heading.cross(targetVector).direction();
player.ship.orientation=player.ship.orientation.rotate(cross,-angle);
}

this.MoveToTarget=function(IndexNo,MinDistance,RandomDistance){
if(DebugOn) log("MoveToTarget: ",IndexNo+") "+ScanName[IndexNo]);
if(system.allShips[Scanner_index[IndexNo]].isValid) player.ship.position=ScanPos[IndexNo].subtract([RDist(MinDistance,RandomDistance),RDist(MinDistance,RandomDistance),RDist(MinDistance,RandomDistance)])
else player.ship.position=system.allShips[Scanner_index[IndexNo]].position.subtract([RDist(MinDistance,RandomDistance),RDist(MinDistance,RandomDistance),RDist(MinDistance,RandomDistance)]);
}

this.RDist=function(Minimum,RandFac){return (Math.random()*RandFac)+Minimum;}

this.shipExitedWitchspace = function(){
var i;
if(missionVariables.lrangeScanner_LongRangeJump == "true"){
	if(system.ID == this.destinationSystem){
	var Secs = clock.adjustedSeconds;
	var TimeJumped = Secs - this.clockSeconds;
	var Days = Math.floor(TimeJumped/(24*3600));
	TimeJumped -= Days*24*3600;
	var Hours =  Math.floor(TimeJumped/3600);
	TimeJumped -= Hours*3600;
	var Minutes = Math.floor(TimeJumped/60);
	player.commsMessage("Arrived: " + System.systemNameForID(this.destinationSystem)+" In "+Days+" Days and "+Hours+" Hours and "+Minutes+" Minutes");
	missionVariables.lrangeScanner_LongRangeJump = null;
	} else this.JumpToDestination();
}
}

this.JumpToDestination = function()
{
	player.ship.position = [9E6*(-1-Math.random()),9E6*(-1-Math.random()),9E6*(-1-Math.random())];
	var ship1 = system.addShips("alloy", 1, player.ship.position.add(player.ship.heading.multiply(160)), 0)[0];
	ship1.switchAI("missileAI.plist");
	ship1.AIState ="EXPLODE";
	ship1.fuel = 7;
	if(system.ID>-1) {
		var MyRoute = System.infoForSystem(galaxyNumber, system.ID).routeToSystem(System.infoForSystem(galaxyNumber, this.destinationSystem),missionVariables.lrangeScanner_jumpMethod);
		if(MyRoute.route.length > 0) {
			player.commsMessage("Jumping to : "+System.systemNameForID(MyRoute.route[1])+", "  +(MyRoute.route.length-1)+" more remains.",6);
			var bool = ship1.exitSystem(MyRoute.route[1]);
		}
	} else {
		player.commsMessage("Jumping to : Unknown system." ,6);
		var bool = ship1.exitSystem(this.destinationSystem);
		if(!bool) var bool = ship1.exitSystem();
	}
	if(!bool && missionVariables.lrangeScanner_LongRangeJump == "true") this.JumpToDestination();
	ship1.remove(true);
	timeAccelerationFactor = 1;
	missionVariables.lrangeScanner_LongRangeJump = true;
}

this.playerStartedJumpCountdown = this.playerCancelledJumpCountdown = this.shipWillDockWithStation = this.shipWillLaunchFromStation = this.playerEnteredNewGalaxy = function (jump){	// These STOP the jumps
	missionVariables.lrangeScanner_LongRangeJump = null;
}

this.guiScreenChanged = function(to, from){
if(DebugOn) log("Screen changed: '",to+"'"+" from '"+from+"'");
if(player.ship.docked) return;
if(player.ship.equipmentStatus("EQ_LONG_RANGE_SCANNER") !== "EQUIPMENT_OK") return;
if(to=="GUI_SCREEN_MAIN" && from=="GUI_SCREEN_MISSION"){
	timeAccelerationFactor=1;
	return;
}
if(to=="GUI_SCREEN_STATUS" && from=="GUI_SCREEN_LONG_RANGE_CHART"){
	player.consoleMessage(" \n \n \n \n \n \n \n \n", 1);
	timeAccelerationFactor = 0.0625;
	if(player.ship.equipmentStatus("EQ_LONG_RANGE_SCANNER_JUMP")!=="EQUIPMENT_OK") LRScannerChoiceString="lRangeScanner_Main"
	else LRScannerChoiceString="lRangeScanner_MainWithLRJ";
	mission.runScreen({title:"Long Range Scanner",message:"Found "+(system.allShips.length-1)+" Entities", choicesKey:LRScannerChoiceString}, this.choice);
}
}

this.missionScreenEnded=function(){timeAccelerationFactor=1;}

this.DisplaySystemInfo=function(){
if(system.ID>-1){
	mission.runScreen({title:"Jump Planner", choicesKey:"lRangeScanner_Jump_Main"}, this.choice);
	this.destinationSystem = player.ship.targetSystem;
	var systemNumber = system.ID;
	mission.addMessageText("Your Targeted system is: " + System.systemNameForID(player.ship.targetSystem) + "(SystemID = " + player.ship.targetSystem + "), Coordinates = " + (Math.floor(System.infoForSystem(galaxyNumber,this.destinationSystem).coordinates.x*100)/100) + "," + (Math.floor(System.infoForSystem(galaxyNumber,this.destinationSystem).coordinates.y*100)/100));
	mission.addMessageText("");
	var MyRoute = system.info.routeToSystem(System.infoForSystem(galaxyNumber,this.destinationSystem), "OPTIMIZED_BY_TIME");
	var MyRouteJ = system.info.routeToSystem(System.infoForSystem(galaxyNumber,this.destinationSystem), "OPTIMIZED_BY_JUMPS");
	var Sys1 ="";
	var i = 1;
	for(i=1;i<MyRoute.route.length;i++) Sys1 += System.systemNameForID(MyRoute.route[i]) + ", ";
	mission.addMessageText("Systems To Jump for minimum Jump Time are " + Sys1 + " Total of " + (MyRoute.route.length-1) + " Jumps, Total " + (Math.floor(MyRoute.distance*100)/100) + " LY's, in " + (Math.floor(MyRoute.time*100)/100) + " Hours");
	mission.addMessageText("");
	var Sys2 ="";
	for(i=1;i<MyRouteJ.route.length;i++) Sys2 += System.systemNameForID(MyRouteJ.route[i]) + ", ";
	mission.addMessageText("Systems To Jump for minimum Jump Count are " + Sys2 + " Total of " + (MyRouteJ.route.length-1) + " Jumps, Total " + (Math.floor(MyRouteJ.distance*100)/100) + " LY's, in " + (Math.floor(MyRouteJ.time*100)/100) + " Hours");
	mission.addMessageText("");
	mission.addMessageText("Coordinates =" + player.ship.galaxyCoordinates.x + " , " +  player.ship.galaxyCoordinates.y);
} else {
	mission.runScreen({title:"Jump Planner", choicesKey:"lRangeScanner_Jump_Main"}, this.choice);
	this.destinationSystem = player.ship.targetSystem;
	mission.addMessageText("Your Targeted system is: " + System.systemNameForID(player.ship.targetSystem) + "(SystemID = " + player.ship.targetSystem + ")");
	mission.addMessageText("");
	mission.addMessageText("Currently you are in witchspace");
	mission.addMessageText("");
	mission.addMessageText("Coordinates =" + player.ship.galaxyCoordinates.x + " , " +  player.ship.galaxyCoordinates.y);
}
}

this.SpacePad=function(Item,NewWidth,Side){	//Return string right or left padded to 'NewWidth' with space
var Pad="";
var WidthNow=defaultFont.measureString(String(Item));
var SpaceWidth=defaultFont.measureString(" ");
var SpacesNeeded=(NewWidth-WidthNow)/SpaceWidth;
if(SpacesNeeded)for(SpaceLoop=1;SpaceLoop<SpacesNeeded;SpaceLoop++)Pad=Pad+" ";	//Generate string of required spaces
if(Side=="R") return String(Item)+Pad;
else return Pad+String(Item);
}

this.TargetDistance=function(Target){	//Calculate and return distance
return Math.round(Target.position.distanceTo(player.ship.position)/10)/100;
}

this.SanityCheck=function(VarName,Suppress){
if(VarName!=null) return true;	//Check variable for unworkable state
if(!Suppress){
//player.commsMessage("LRS error: Null or undefined")
//fun to reduce reliability of scanner if service overdue? heh!
//but only after solving why it does that!?
//SOLVED - RFM on parseInt ffs!
//Log("LongRangeScanner:SanityCheck: variable equates to null")
}
}

//Match 'StringData' re length, header-content and serial
this.IsMenuOption=function(StringData,DataLength,HeadData,LowerLimit,UpperLimit){
var MenSerial="",MLoop=0;
if(StringData.length!==DataLength) return;	//Ensure correct length
if(StringData.indexOf(HeadData)!==0) return;	//Ensure prefixed by header
//Determine serial
for(MLoop=HeadData.length;MLoop<StringData.length;MLoop++) MenSerial=MenSerial+StringData.charAt(MLoop);
if(NumInBounds(parseInt(MenSerial,10),LowerLimit,UpperLimit)) return parseInt(MenSerial,10);	//Ensure serial is within bounds
}

this.MenuSerial=function(SelectionText,CharStart,NoChars){	//Return consecutive characters as number
var NumString="";
for(CharLoop=CharStart;CharLoop<=CharStart+NoChars;CharLoop++) NumString=NumString.concat(SelectionText.charAt(CharLoop));
return parseInt(NumString,10);
}

this.NumInBounds=function(NumVar,MinNum,MaxNum){if(NumVar>=MinNum && NumVar<=MaxNum) return true;}	//Does number fall between minimum and maximum values

//Assemble string from bounty value
this.BountyAsString=function(BountyValue,BountyWidth){
if(BountyValue) return "Cr("+SpacePad(String(BountyValue),BountyWidth,"L")+")";	//Bounty exists
var BountyPad=defaultFont.measureString("Cr()");	//No bounty = empty column
return SpacePad("",BountyWidth+BountyPad,"L");
}

this.IntegerAsString=function(NumValue){return parseInt(NumValue,10);}	//Return string number as integer